/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import novamachina.exnihilosequentia.client.render.AbstractModBlockRenderer;
import novamachina.exnihilosequentia.client.render.UVLocation;
import novamachina.exnihilosequentia.client.render.VertexLocation;
import novamachina.exnihilosequentia.common.blockentity.barrel.AbstractBarrelEntity;
import novamachina.exnihilosequentia.common.utility.Color;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class BarrelRender
extends AbstractModBlockRenderer<AbstractBarrelEntity> {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    public BarrelRender(@Nonnull BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public static void register(@Nonnull BlockEntityType<? extends AbstractBarrelEntity> tileEntityType) {
        logger.debug("Register barrel renderer");
        BlockEntityRenderers.m_173590_(tileEntityType, BarrelRender::new);
    }

    public void render(@Nonnull AbstractBarrelEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite sprite;
        VertexConsumer builder;
        ResourceLocation inventoryTexture = tileEntity.getSolidTexture();
        ResourceLocation solidTexture = Blocks.f_50050_.getRegistryName();
        Fluid fluid = tileEntity.getFluid();
        ResourceLocation fluidTexture = fluid != null ? fluid.getAttributes().getStillTexture() : null;
        Color fluidColor = fluid != null ? new Color(fluid.getAttributes().getColor()) : Color.INVALID_COLOR;
        this.renderFluid(tileEntity, matrixStack, buffer, combinedLightIn, fluidTexture, fluidColor, new UVLocation(0.0625f, 0.9375f));
        if (inventoryTexture != null) {
            builder = buffer.m_6299_(RenderType.m_110451_());
            sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation(inventoryTexture.m_135827_(), "block/" + inventoryTexture.m_135815_()));
            float fillAmount = 0.995f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.995f, 0.9375f), new UVLocation(sprite.m_118409_(), sprite.m_118412_()), Color.WHITE, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.995f, 0.9375f), new UVLocation(sprite.m_118410_(), sprite.m_118412_()), Color.WHITE, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.995f, 0.0625f), new UVLocation(sprite.m_118410_(), sprite.m_118411_()), Color.WHITE, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.995f, 0.0625f), new UVLocation(sprite.m_118409_(), sprite.m_118411_()), Color.WHITE, combinedLightIn);
            matrixStack.m_85849_();
        }
        if (tileEntity.getSolidAmount() > 0) {
            builder = buffer.m_6299_(RenderType.m_110466_());
            if (solidTexture != null) {
                sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation(solidTexture.m_135827_(), "block/" + solidTexture.m_135815_()));
                Color color = this.getBlockColor(solidTexture, tileEntity);
                float fillAmount = 0.75f * Math.min(tileEntity.getSolidProportion(), 1.0f) - 0.005f;
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_85837_(-0.5, -0.5, -0.5);
                this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.25f + fillAmount, 0.9375f), new UVLocation(sprite.m_118409_(), sprite.m_118412_()), color, combinedLightIn);
                this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.25f + fillAmount, 0.9375f), new UVLocation(sprite.m_118410_(), sprite.m_118412_()), color, combinedLightIn);
                this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.25f + fillAmount, 0.0625f), new UVLocation(sprite.m_118410_(), sprite.m_118411_()), color, combinedLightIn);
                this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.25f + fillAmount, 0.0625f), new UVLocation(sprite.m_118409_(), sprite.m_118411_()), color, combinedLightIn);
            }
            matrixStack.m_85849_();
        }
    }

    @Nonnull
    private Color getBlockColor(@Nullable ResourceLocation solidTexture, @Nonnull AbstractBarrelEntity tileEntity) {
        if (solidTexture != null && solidTexture.toString().contains("leaves") && tileEntity.m_58904_() != null) {
            return new Color(((Biome)tileEntity.m_58904_().m_204166_(tileEntity.m_58899_()).m_203334_()).m_47542_());
        }
        return Color.WHITE;
    }
}

